/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.base.impl.event;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.quiltmc.qsl.base.api.entrypoint.ModInitializer;
import org.quiltmc.qsl.base.api.event.Event;
import org.quiltmc.qsl.base.api.event.EventAwareListener;
import org.quiltmc.qsl.base.api.event.ListenerPhase;
import org.quiltmc.qsl.base.api.event.client.ClientEventAwareListener;
import org.quiltmc.qsl.base.api.event.server.DedicatedServerEventAwareListener;

@ApiStatus.Internal
public final class EventRegistry
implements ModInitializer {
    private static List<Event<?>> pendingEventsRegistration = new ArrayList();
    private static boolean initialized = false;

    public static void listenAll(Object listener, Event<?> ... events) {
        Map<Class<?>, class_2960> listenedPhases = EventRegistry.getListenedPhases(listener.getClass());
        for (Event<?> event : events) {
            if (!event.getType().isAssignableFrom(listener.getClass())) {
                throw new IllegalArgumentException("Given object " + listener + " is not a listener of event " + event);
            }
            if (event.getType().getTypeParameters().length > 0) {
                throw new IllegalArgumentException("Cannot register a listener for the event " + event + " which is using generic parameters with listenAll.");
            }
            listenedPhases.putIfAbsent(event.getType(), Event.DEFAULT_PHASE);
        }
        for (Event<?> event : events) {
            event.register(listenedPhases.get(event.getType()), listener);
        }
    }

    private static Map<Class<?>, class_2960> getListenedPhases(Class<?> listenerClass) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (Annotation annotation : listenerClass.getAnnotations()) {
            if (!(annotation instanceof ListenerPhase)) continue;
            ListenerPhase phase = (ListenerPhase)annotation;
            map.put(phase.callbackTarget(), (Object)new class_2960(phase.namespace(), phase.path()));
        }
        return map;
    }

    public static <T> void register(Event<T> event) {
        if (!initialized) {
            pendingEventsRegistration.add(event);
            return;
        }
        for (EventSideTarget target : EventSideTarget.VALUES) {
            if (!target.listenerClass().isAssignableFrom(event.getType())) continue;
            List entrypoints = FabricLoader.getInstance().getEntrypoints(target.entrypointKey(), target.listenerClass());
            for (Object entrypoint : entrypoints) {
                Map<Class<?>, class_2960> listenedPhases = EventRegistry.getListenedPhases(entrypoint.getClass());
                if (!event.getType().isAssignableFrom(entrypoint.getClass())) continue;
                class_2960 phase = listenedPhases.getOrDefault(event.getType(), Event.DEFAULT_PHASE);
                event.register(phase, entrypoint);
            }
        }
    }

    @Override
    public void onInitialize(ModContainer mod) {
        initialized = true;
        for (Event<?> event : pendingEventsRegistration) {
            EventRegistry.register(event);
        }
        pendingEventsRegistration = null;
    }

    static enum EventSideTarget {
        CLIENT("client_events", ClientEventAwareListener.class),
        COMMON("events", EventAwareListener.class),
        DEDICATED_SERVER("server_events", DedicatedServerEventAwareListener.class);

        public static final List<EventSideTarget> VALUES;
        private final String entrypointKey;
        private final Class<?> listenerClass;

        private EventSideTarget(String entrypointKey, Class<?> listenerClass) {
            this.entrypointKey = entrypointKey;
            this.listenerClass = listenerClass;
        }

        public String entrypointKey() {
            return this.entrypointKey;
        }

        public Class<?> listenerClass() {
            return this.listenerClass;
        }

        static {
            VALUES = List.of(EventSideTarget.values());
        }
    }
}

